// Generate mail content
int hMailObject = CreateMail("user@example.com", "Hello World!", "The quick brown fox jumps over the lazy dog.");
AddMailTo(hMailObject, "user@example.com");

// Schedule mail and remember the message queue ID
int nMessageQueueID = SendMail(hMailObject);
DestroyMail(hMailObject);

// Wait for message being processed
RegisterEvent(Frame, OnFrame);
Suspend();

function OnFrame()
{
	if (MailIsValidID(nMessageQueueID) == 0)
	{
		alert(Unknown mail ID!\n");
		exit; // shutdown suspended macro event
	}
	
	// Is message being processed?
	if (MailIsProcessed(nMessageQueueID) == 0)
	{
		printf("Waiting for message being processed ... \n");
	}
	else
	{
		printf("Message was processed.\n");
		
		// Is a response available?
		if (MailIsResponseAvailable(nMessageQueueID))
		{
			// Check if sending was successful
			if (MailIsTransmissionSuccessful
					(nMessageQueueID) == 1)
				printf("Sending mail successful.\n");
			else
				alert("Sending message failed!\n");
		}
		
		exit; // Shutdown suspended macro event
	}
}	
